"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const pergunta_repository_1 = require("../repositories/pergunta.repository");
class PerguntaUseCase {
    constructor() {
        this.perguntaRepository = new pergunta_repository_1.PerguntaRepositoryPrisma();
    }
    async create({ texto, subcategoria_id }) {
        const result = await this.perguntaRepository.create({ texto, subcategoria_id });
        return result;
    }
    async findAll() {
        const result = await this.perguntaRepository.findAll();
        return result;
    }
    async findById(id) {
        const result = await this.perguntaRepository.findById(id);
        return result;
    }
    async update({ id, texto, subcategoria_id }) {
        const result = await this.perguntaRepository.update({ id, texto, subcategoria_id });
        return result;
    }
    async delete(id) {
        await this.perguntaRepository.delete(id);
    }
}
;
exports.default = PerguntaUseCase;
