import { IPacoteRepository, Pacote } from "../interfaces/pacotes.interfaces";
import PackRepositoryPrisma from "../repositories/pacote.repository";

class PackUseCase {
    private packRepository: IPacoteRepository;
    constructor() {
        this.packRepository = new PackRepositoryPrisma();
    }

    async create({ nome, quantidadeCreditos, valor, destaque }: Pacote): Promise<Pacote> {
        const result = await this.packRepository.create({ nome, quantidadeCreditos, valor, destaque });
        return result;
    }

    async findAll(): Promise<Pacote[]> {
        const result = await this.packRepository.findAll();
        return result;
    }

    async findById(id: number): Promise<Pacote | null> {
        const result = await this.packRepository.findById(id);
        return result;
    }

    async update({ id, nome, quantidadeCreditos, valor, destaque }: Pacote): Promise<Pacote> {
        const result = await this.packRepository.update({ id, nome, quantidadeCreditos, valor, destaque });
        return result;
    }

    async delete(id: number): Promise<void> {
        await this.packRepository.delete(id);
    }
};

export default PackUseCase;   
