"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pacote_repository_1 = __importDefault(require("../repositories/pacote.repository"));
class PackUseCase {
    constructor() {
        this.packRepository = new pacote_repository_1.default();
    }
    async create({ nome, quantidadeCreditos, valor, destaque }) {
        const result = await this.packRepository.create({ nome, quantidadeCreditos, valor, destaque });
        return result;
    }
    async findAll() {
        const result = await this.packRepository.findAll();
        return result;
    }
    async findById(id) {
        const result = await this.packRepository.findById(id);
        return result;
    }
    async update({ id, nome, quantidadeCreditos, valor, destaque }) {
        const result = await this.packRepository.update({ id, nome, quantidadeCreditos, valor, destaque });
        return result;
    }
    async delete(id) {
        await this.packRepository.delete(id);
    }
}
;
exports.default = PackUseCase;
