import Fastify from "fastify";
import { authRoutes } from "./routes/auth.routes";
import { userRoutes } from "./routes/user.routes";
import { packsRoutes } from "./routes/pacote.routes";
import { categoriaRoutes } from "./routes/categoria.routes";
import { subcategoriaRoutes } from "./routes/subcategoria.routes";
import { perguntaRoutes } from "./routes/pergunta.routes";

const fastify = Fastify();
fastify.register(authRoutes, { prefix: "/auth" });
fastify.register(userRoutes, { prefix: "/users" });
fastify.register(packsRoutes, { prefix: "/packs" });
fastify.register(categoriaRoutes, { prefix: "/categoria" });
fastify.register(subcategoriaRoutes, { prefix: "/subcategoria" });
fastify.register(perguntaRoutes, { prefix: "/pergunta" });

fastify.listen({ port: process.env.PORT ? Number(process.env.PORT) : 3333 }, (err, address) => {
    if (err) {
        console.error(err);
        process.exit(1);
    }
    console.log(`HTTP Server Running at ${address}`);
});