"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fastify_1 = __importDefault(require("fastify"));
const auth_routes_1 = require("./routes/auth.routes");
const user_routes_1 = require("./routes/user.routes");
const pacote_routes_1 = require("./routes/pacote.routes");
const categoria_routes_1 = require("./routes/categoria.routes");
const subcategoria_routes_1 = require("./routes/subcategoria.routes");
const pergunta_routes_1 = require("./routes/pergunta.routes");
const fastify = (0, fastify_1.default)();
fastify.register(auth_routes_1.authRoutes, { prefix: "/auth" });
fastify.register(user_routes_1.userRoutes, { prefix: "/users" });
fastify.register(pacote_routes_1.packsRoutes, { prefix: "/packs" });
fastify.register(categoria_routes_1.categoriaRoutes, { prefix: "/categoria" });
fastify.register(subcategoria_routes_1.subcategoriaRoutes, { prefix: "/subcategoria" });
fastify.register(pergunta_routes_1.perguntaRoutes, { prefix: "/pergunta" });
fastify.listen({ port: process.env.PORT ? Number(process.env.PORT) : 3333 }, (err, address) => {
    if (err) {
        console.error(err);
        process.exit(1);
    }
    console.log(`HTTP Server Running at ${address}`);
});
