import { FastifyInstance } from "fastify";
import { UserUseCase } from "../userCases/user.usercases";
import { authMiddleware } from "../middlewares/auth.middleware";
import { UserCreate } from "../interfaces/auth.interfaces";

export async function userRoutes(fastify: FastifyInstance) {
    const userUserCase = new UserUseCase()
    fastify.addHook('preHandler', authMiddleware as any);

    fastify.get<{ Body: UserCreate }>('/', async (req, reply) => {
        const email = req.headers['email'] as string;
        try {
            const data = await userUserCase.findByEmail({ email })
            return reply.send(data);
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.get<{ Body: UserCreate }>('/:id', async (req, reply) => {
        const id = req.headers['id'] as unknown as number;
        try {
            const data = await userUserCase.findById({ id })
            return reply.send(data);
        } catch (error) {
            reply.status(500).send(error)
        }
    })


    fastify.delete<{ Params: { id: string } }>('/:id', async (req, reply) => {
        const id = req.params.id as unknown as number;
        try {
            await userUserCase.deleteUser({ id })
            return reply.send({ message: 'User deleted' });
        } catch (error) {
            reply.status(500).send(error)
        }
    })
};