"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.userRoutes = userRoutes;
const user_usercases_1 = require("../userCases/user.usercases");
const auth_middleware_1 = require("../middlewares/auth.middleware");
async function userRoutes(fastify) {
    const userUserCase = new user_usercases_1.UserUseCase();
    fastify.addHook('preHandler', auth_middleware_1.authMiddleware);
    fastify.get('/', async (req, reply) => {
        const email = req.headers['email'];
        try {
            const data = await userUserCase.findByEmail({ email });
            return reply.send(data);
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.get('/:id', async (req, reply) => {
        const id = req.headers['id'];
        try {
            const data = await userUserCase.findById({ id });
            return reply.send(data);
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.delete('/:id', async (req, reply) => {
        const id = req.params.id;
        try {
            await userUserCase.deleteUser({ id });
            return reply.send({ message: 'User deleted' });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
}
;
