"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.perguntaRoutes = perguntaRoutes;
const pergunta_usercases_1 = __importDefault(require("../userCases/pergunta.usercases"));
const auth_middleware_1 = require("../middlewares/auth.middleware");
async function perguntaRoutes(fastify) {
    const perguntaUserCase = new pergunta_usercases_1.default();
    fastify.post('/register', { preHandler: auth_middleware_1.authMiddleware }, async (req, reply) => {
        const { texto, subcategoria_id } = req.body;
        try {
            const data = await perguntaUserCase.create({ texto, subcategoria_id });
            return reply.send({ message: "Registro realizado com sucesso", data });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.get('/', async (req, reply) => {
        try {
            const data = await perguntaUserCase.findAll();
            return reply.send(data);
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.get('/:id', async (req, reply) => {
        const id = req.headers['id'];
        try {
            const data = await perguntaUserCase.findById(id);
            return reply.send(data);
        }
        catch (error) {
            console.log(error);
            reply.status(500).send(error);
        }
    });
    fastify.put('/update', { preHandler: auth_middleware_1.authMiddleware }, async (req, reply) => {
        const { id, texto, subcategoria_id } = req.body;
        try {
            const data = await perguntaUserCase.update({ id, texto, subcategoria_id });
            return reply.send({ message: "Registro atualizado com sucesso", data });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.delete('/delete/:id', { preHandler: auth_middleware_1.authMiddleware }, async (req, reply) => {
        const { id } = req.params;
        try {
            await perguntaUserCase.delete(id);
            return reply.send({ message: "Registro deletado com sucesso" });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
}
