import { FastifyInstance } from "fastify";
import PackUseCase from "../userCases/pacote.usercases";
import { Pacote } from "../interfaces/pacotes.interfaces";

export async function packsRoutes(fastify: FastifyInstance) {
    const packsUserCase = new PackUseCase();


    fastify.post<{ Body: Pacote }>('/register', async (req, reply) => {
        const { nome, quantidadeCreditos, valor, destaque } = req.body
        try {
            const data = await packsUserCase.create({ nome, quantidadeCreditos, valor, destaque })
            return reply.send({ message: "Registro realizado com sucesso", data });
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.get('/all', async (req, reply) => {
        try {
            const data = await packsUserCase.findAll()
            return reply.send(data);
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.get<{ Params: { id: number } }>('/:id', async (req, reply) => {
        const { id } = req.params as { id: number };
        try {
            const data = await packsUserCase.findById(id)
            return reply.send(data);
        } catch (error) {
            console.log(error)
            reply.status(500).send(error)
        }
    })

    fastify.put<{ Body: Pacote; Params: { id: number } }>('/:id', async (req, reply) => {
        const { id } = req.params
        const data = req.body
        try {
            const result = await packsUserCase.update({ ...data, id: Number(id) })
            return reply.send(result);
        } catch (error) {
            console.log(error)
            reply.status(500).send(error)
        }
    })

    fastify.delete<{ Params: { id: number } }>('/:id', async (req, reply) => {
        const { id } = req.params
        try {
            await packsUserCase.delete(id)
            return reply.send({ message: 'Pacote deletado' });
        } catch (error) {
            reply.status(500).send(error)
        }
    })
};
