"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.packsRoutes = packsRoutes;
const pacote_usercases_1 = __importDefault(require("../userCases/pacote.usercases"));
async function packsRoutes(fastify) {
    const packsUserCase = new pacote_usercases_1.default();
    fastify.post('/register', async (req, reply) => {
        const { nome, quantidadeCreditos, valor, destaque } = req.body;
        try {
            const data = await packsUserCase.create({ nome, quantidadeCreditos, valor, destaque });
            return reply.send({ message: "Registro realizado com sucesso", data });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.get('/all', async (req, reply) => {
        try {
            const data = await packsUserCase.findAll();
            return reply.send(data);
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.get('/:id', async (req, reply) => {
        const { id } = req.params;
        try {
            const data = await packsUserCase.findById(id);
            return reply.send(data);
        }
        catch (error) {
            console.log(error);
            reply.status(500).send(error);
        }
    });
    fastify.put('/:id', async (req, reply) => {
        const { id } = req.params;
        const data = req.body;
        try {
            const result = await packsUserCase.update({ ...data, id: Number(id) });
            return reply.send(result);
        }
        catch (error) {
            console.log(error);
            reply.status(500).send(error);
        }
    });
    fastify.delete('/:id', async (req, reply) => {
        const { id } = req.params;
        try {
            await packsUserCase.delete(id);
            return reply.send({ message: 'Pacote deletado' });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
}
;
