"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.authRoutes = authRoutes;
const auth_usercases_1 = require("../userCases/auth.usercases");
async function authRoutes(fastify) {
    const authUserCase = new auth_usercases_1.AuthUserCase();
    fastify.post('/register', async (req, reply) => {
        const { email, password, role, cliente, profissional } = req.body;
        try {
            const data = await authUserCase.create({ email, password, role, cliente, profissional });
            return reply.send({ message: "Registro realizado com sucesso", data });
        }
        catch (error) {
            console.log(error);
            reply.status(500).send(error);
        }
    });
    fastify.post('/login', async (req, reply) => {
        const { email, password } = req.body;
        try {
            const user = await authUserCase.login({ email, password });
            return reply.send({ message: "Login realizado com sucesso", user });
        }
        catch (error) {
            console.log(error);
            reply.status(500).send(error);
        }
    });
    /* Forgot Password */
    fastify.post('/forgot-password', async (req, reply) => {
        const { email } = req.body;
        if (!email) {
            return reply.status(400).send({ message: "Email é obrigatório" });
        }
        try {
            await authUserCase.forgotPassword({ email });
            return reply.send({ message: "Email de redefinição de senha enviado com sucesso" });
        }
        catch (error) {
            return reply.status(500).send({ message: "Erro ao enviar email de redefinição de senha", error });
        }
    });
    fastify.post('/reset-password', async (req, reply) => {
        const { email, token, password } = req.body;
        try {
            await authUserCase.resetPassword({ email, token, password });
            return reply.send({ message: "Senha alterada com sucesso" });
        }
        catch (error) {
            return reply.status(500).send({ message: "Erro ao enviar email de redefinição de senha", error });
        }
    });
}
