import { prisma } from "../database/prisma.client";
import { ISubCategoriaRepository, Subcategoria } from "../interfaces/subcategoria.interfaces";


class SubCategoriaRepositoryPrisma implements ISubCategoriaRepository {
    async create(data: Subcategoria): Promise<Subcategoria> {
        const result = await prisma.subcategoria.create({
            data: {
                nome: data.nome,
                descricao: data.descricao,
                categoria: {
                    connect: { id: data.categoria_id }
                }
            }
        });
        return result as never;
    };

    async findAll(): Promise<Subcategoria[]> {
        const result = await prisma.subcategoria.findMany({
            orderBy: {
                nome: 'desc'
            }
        });
        return result as never;
    };

    async findById(id: number): Promise<Subcategoria | null> {
        const numericId = Number(id);

        const result = await prisma.subcategoria.findUnique({
            where: {
                id: numericId
            }
        });
        return result as never;
    };

    async update(data: Subcategoria): Promise<Subcategoria> {
        const result = await prisma.subcategoria.update({
            where: {
                id: data.id
            },
            data: {
                nome: data.nome,
                descricao: data.descricao
            }
        });
        return result as never;
    };

    async delete(id: number): Promise<void> {
        const numericId = Number(id);

        await prisma.subcategoria.delete({
            where: {
                id: numericId
            }
        });
    };
}

export default SubCategoriaRepositoryPrisma;