"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const prisma_client_1 = require("../database/prisma.client");
class SubCategoriaRepositoryPrisma {
    async create(data) {
        const result = await prisma_client_1.prisma.subcategoria.create({
            data: {
                nome: data.nome,
                descricao: data.descricao,
                categoria: {
                    connect: { id: data.categoria_id }
                }
            }
        });
        return result;
    }
    ;
    async findAll() {
        const result = await prisma_client_1.prisma.subcategoria.findMany({
            orderBy: {
                nome: 'desc'
            }
        });
        return result;
    }
    ;
    async findById(id) {
        const numericId = Number(id);
        const result = await prisma_client_1.prisma.subcategoria.findUnique({
            where: {
                id: numericId
            }
        });
        return result;
    }
    ;
    async update(data) {
        const result = await prisma_client_1.prisma.subcategoria.update({
            where: {
                id: data.id
            },
            data: {
                nome: data.nome,
                descricao: data.descricao
            }
        });
        return result;
    }
    ;
    async delete(id) {
        const numericId = Number(id);
        await prisma_client_1.prisma.subcategoria.delete({
            where: {
                id: numericId
            }
        });
    }
    ;
}
exports.default = SubCategoriaRepositoryPrisma;
