"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PerguntaRepositoryPrisma = void 0;
const prisma_client_1 = require("../database/prisma.client");
class PerguntaRepositoryPrisma {
    async create(data) {
        const result = await prisma_client_1.prisma.pergunta.create({
            data: {
                texto: data.texto,
                subcategoria: {
                    connect: { id: data.subcategoria_id }
                }
            }
        });
        return result;
    }
    ;
    async findAll() {
        const result = await prisma_client_1.prisma.pergunta.findMany();
        return result;
    }
    ;
    async findById(id) {
        const numericId = Number(id);
        const result = await prisma_client_1.prisma.pergunta.findUnique({
            where: {
                id: numericId
            }
        });
        return result;
    }
    ;
    async update(data) {
        const result = await prisma_client_1.prisma.pergunta.update({
            where: { id: data.id },
            data: {
                texto: data.texto,
                subcategoria: {
                    connect: { id: data.subcategoria_id }
                }
            }
        });
        return result;
    }
    ;
    async delete(id) {
        await prisma_client_1.prisma.pergunta.delete({
            where: { id }
        });
    }
    ;
}
exports.PerguntaRepositoryPrisma = PerguntaRepositoryPrisma;
;
