import { IPacoteRepository, Pacote } from "../interfaces/pacotes.interfaces";
import { prisma } from "../database/prisma.client";

class PackRepositoryPrisma implements IPacoteRepository {
    async create(data: Pacote): Promise<Pacote> {
        const result = await prisma.pacoteCredito.create({
            data: {
                nome: data.nome,
                quantidadeCreditos: Number(data.quantidadeCreditos),
                valor: data.valor,
                destaque: data.destaque
            }
        });
        return result as never;
    };

    async findAll(): Promise<Pacote[]> {
        const result = await prisma.pacoteCredito.findMany({
            orderBy: {
                destaque: 'desc'
            }
        });
        return result as never;
    };

    async findById(id: number): Promise<Pacote | null> {
        const numericId = Number(id);

        const result = await prisma.pacoteCredito.findUnique({
            where: {
                id: numericId
            }
        });
        return result as never;
    };

    async update(data: Pacote): Promise<Pacote> {
        const result = await prisma.pacoteCredito.update({
            where: {
                id: data.id
            },
            data: {
                nome: data.nome,
                quantidadeCreditos: Number(data.quantidadeCreditos),
                valor: data.valor,
                destaque: data.destaque
            }
        });
        return result as never;
    };

    async delete(id: number): Promise<void> {
        const numericId = Number(id);

        await prisma.pacoteCredito.delete({
            where: {
                id: numericId
            }
        });
    };
};


export default PackRepositoryPrisma;