"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const prisma_client_1 = require("../database/prisma.client");
class CategoriaRepositoryPrisma {
    async create(data) {
        const result = await prisma_client_1.prisma.categoria.create({
            data: {
                nome: data.nome,
                descricao: data.descricao
            }
        });
        return result;
    }
    ;
    async findAll() {
        const result = await prisma_client_1.prisma.categoria.findMany({
            orderBy: {
                id: 'desc'
            }
        });
        return result;
    }
    ;
    async findById(id) {
        const numericId = Number(id);
        const result = await prisma_client_1.prisma.categoria.findUnique({
            where: {
                id: numericId
            }
        });
        return result;
    }
    ;
    async update(data) {
        const result = await prisma_client_1.prisma.categoria.update({
            where: {
                id: data.id
            },
            data: {
                nome: data.nome,
                descricao: data.descricao
            }
        });
        return result;
    }
    ;
    async delete(id) {
        const numericId = Number(id);
        await prisma_client_1.prisma.categoria.delete({
            where: {
                id: numericId
            }
        });
    }
    ;
}
exports.default = CategoriaRepositoryPrisma;
