"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authMiddleware = authMiddleware;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const prisma_client_1 = require("../database/prisma.client");
const api_error_1 = require("../exceptions/api.error");
async function authMiddleware(req, reply) {
    try {
        // Verificar se o token está presente no cabeçalho da solicitação
        const authHeader = req.headers.authorization;
        if (!authHeader) {
            return reply.status(401).send({ message: 'Token não fornecido' });
        }
        const token = authHeader.split(' ')[1];
        if (!token) {
            return reply.status(401).send({ message: 'Token malformado' });
        }
        // Decodificar e verificar o token JWT
        const secret = process.env.JWT_PASS ?? "";
        if (!secret) {
            throw new Error("JWT_PASS não está definido");
        }
        // Decodificar e verificar o token JWT
        const payload = jsonwebtoken_1.default.verify(token, secret);
        const { id, exp } = payload;
        if (Date.now() >= exp * 1000) {
            throw new api_error_1.UnauthorizedError("Token expirado");
        }
        // Buscar o usuário no banco de dados
        const user = await prisma_client_1.prisma.user.findUnique({ where: { id: id } });
        if (!user) {
            return reply.status(401).send({ message: 'Usuário não encontrado' });
        }
        req.user = { ...user, password: undefined };
    }
    catch (error) {
        return reply.status(401).send({ message: 'Autenticação falhou', error });
    }
}
