interface Cliente {
    id: number;
    nome?: string;
    telefone?: string;
    sexo?: string;
    redeSocial?: string;
}

interface Profissional {
    id: number;
    nome?: string;
    telefone?: string;
    cpf?: string;
    saldoCreditos?: number;
}

export interface User {
    id: number;
    email: string;
    password: string;
    role?: string;
    clienteId?: number;
    profissionalId?: number;
    dataCadastro?: Date;
    cliente?: Cliente[];
    profissional?: Profissional[];
};

export interface IUserWithoutPassword extends Omit<User, 'password'> {
    token?: string;
}

export interface IUserRepository {
    findByEmail(email: string): Promise<IUserWithoutPassword | null>;
    findById(id: number): Promise<IUserWithoutPassword | null>;
    update(data: User): Promise<IUserWithoutPassword>;
    delete(id: number): Promise<void>;
}