export interface Pacote {
    id?: number;
    nome: string;
    quantidadeCreditos: string;
    valor: number;
    destaque?: boolean;
};



export interface IPacoteRepository {
    findAll(): Promise<Pacote[]>;
    findById(id: number): Promise<Pacote | null>;
    create(data: Pacote): Promise<Pacote>;
    update(data: Pacote): Promise<Pacote>;
    delete(id: number): Promise<void>;
}