export interface IUser {
    email: string;
    password: string;
    role?: any;
}

export interface IUserWithoutPassword extends Omit<IUser, 'password'> {
    token?: string;
}

export interface UserCreate {
    email: string;
    password: string;
    role?: any;
    cliente?: {
        nome: string;
        telefone?: string;
        sexo?: string;
        redeSocial?: string;
    };
    profissional?: {
        nome?: string;
        telefone?: string;
        cpf: string;
    };
}

export interface IResetPassword {
    email: string;
    token: string;
    password: string;
}


export interface IAuthRepository {
    create(data: UserCreate): Promise<IUser>;
    login(data: UserCreate): Promise<IUserWithoutPassword>;
    forgotPassword(email: string): Promise<void>;
    resetPassword(data: IResetPassword): Promise<void>;
}
