-- AlterTable
ALTER TABLE "servicos" ADD COLUMN     "especialidadeId" INTEGER;

-- CreateTable
CREATE TABLE "classificacoes" (
    "id" SERIAL NOT NULL,
    "nome" TEXT NOT NULL,
    "subcategoriaId" INTEGER,

    CONSTRAINT "classificacoes_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "perguntas" (
    "id" SERIAL NOT NULL,
    "texto" TEXT NOT NULL,
    "subcategoriaId" INTEGER NOT NULL,

    CONSTRAINT "perguntas_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "_ProfissionalEspecialidade" (
    "A" INTEGER NOT NULL,
    "B" INTEGER NOT NULL
);

-- CreateIndex
CREATE UNIQUE INDEX "_ProfissionalEspecialidade_AB_unique" ON "_ProfissionalEspecialidade"("A", "B");

-- CreateIndex
CREATE INDEX "_ProfissionalEspecialidade_B_index" ON "_ProfissionalEspecialidade"("B");

-- AddForeignKey
ALTER TABLE "servicos" ADD CONSTRAINT "servicos_especialidadeId_fkey" FOREIGN KEY ("especialidadeId") REFERENCES "classificacoes"("id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "classificacoes" ADD CONSTRAINT "classificacoes_subcategoriaId_fkey" FOREIGN KEY ("subcategoriaId") REFERENCES "subcategorias"("id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "perguntas" ADD CONSTRAINT "perguntas_subcategoriaId_fkey" FOREIGN KEY ("subcategoriaId") REFERENCES "subcategorias"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "_ProfissionalEspecialidade" ADD CONSTRAINT "_ProfissionalEspecialidade_A_fkey" FOREIGN KEY ("A") REFERENCES "classificacoes"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "_ProfissionalEspecialidade" ADD CONSTRAINT "_ProfissionalEspecialidade_B_fkey" FOREIGN KEY ("B") REFERENCES "profissionais"("id") ON DELETE CASCADE ON UPDATE CASCADE;
